/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.DoubleBuffer;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Double8;

public final class VectorDouble8
implements TornadoCollectionInterface<DoubleBuffer> {
    public static final Class<VectorDouble8> TYPE = VectorDouble8.class;
    private static final int ELEMENT_SIZE = 8;
    private final DoubleArray storage;
    private final int numElements;

    VectorDouble8(int numElements, DoubleArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorDouble8(DoubleArray array) {
        this(array.getSize() / 8, array);
    }

    public VectorDouble8(int numElements) {
        this(numElements, new DoubleArray(numElements * 8));
    }

    public int vectorWidth() {
        return 8;
    }

    private int toIndex(int index) {
        return index * 8;
    }

    public Double8 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Double8 loadFromArray(DoubleArray array, int index) {
        Double8 result = new Double8();
        for (int i = 0; i < 8; ++i) {
            result.set(i, array.get(index + i));
        }
        return result;
    }

    public void set(int index, Double8 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Double8 value, DoubleArray array, int index) {
        for (int i = 0; i < 8; ++i) {
            array.set(index + i, value.get(i));
        }
    }

    public void set(VectorDouble8 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(DoubleArray values) {
        VectorDouble8 vector = new VectorDouble8(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(double value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorDouble8 duplicate() {
        VectorDouble8 vector = new VectorDouble8(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 8) {
            return String.format("VectorDouble8 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Double8 sum() {
        Double8 result = new Double8();
        for (int i = 0; i < this.numElements; ++i) {
            result = Double8.add(result, this.get(i));
        }
        return result;
    }

    public Double8 min() {
        Double8 result = new Double8();
        for (int i = 0; i < this.numElements; ++i) {
            result = Double8.min(result, this.get(i));
        }
        return result;
    }

    public Double8 max() {
        Double8 result = new Double8();
        for (int i = 0; i < this.numElements; ++i) {
            result = Double8.max(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(DoubleBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public DoubleBuffer asBuffer() {
        return DoubleBuffer.wrap(this.storage.toHeapArray());
    }

    public DoubleBuffer asBuffer(DoubleBuffer buffer) {
        return this.asBuffer().put(buffer);
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public DoubleArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

