/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.DoubleBuffer;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Double4;

public final class VectorDouble4
implements TornadoCollectionInterface<DoubleBuffer> {
    public static final Class<VectorDouble4> TYPE = VectorDouble4.class;
    private static final int ELEMENT_SIZE = 4;
    private final DoubleArray storage;
    private final int numElements;

    VectorDouble4(int numElements, DoubleArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorDouble4(DoubleArray array) {
        this(array.getSize() / 4, array);
    }

    public VectorDouble4(int numElements) {
        this(numElements, new DoubleArray(numElements * 4));
    }

    public int vectorWidth() {
        return 4;
    }

    private int toIndex(int index) {
        return index * 4;
    }

    public Double4 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Double4 loadFromArray(DoubleArray array, int index) {
        Double4 result = new Double4();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        result.setW(array.get(index + 3));
        return result;
    }

    public void set(int index, Double4 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Double4 value, DoubleArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
        array.set(index + 3, value.getW());
    }

    public void set(VectorDouble4 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(DoubleArray values) {
        VectorDouble4 vector = new VectorDouble4(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(float value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorDouble4 duplicate() {
        VectorDouble4 vector = new VectorDouble4(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 4) {
            return String.format("VectorDouble4 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Double4 sum() {
        Double4 result = new Double4();
        for (int i = 0; i < this.numElements; ++i) {
            result = Double4.add(result, this.get(i));
        }
        return result;
    }

    public Double4 min() {
        Double4 result = new Double4();
        for (int i = 0; i < this.numElements; ++i) {
            result = Double4.min(result, this.get(i));
        }
        return result;
    }

    public Double4 max() {
        Double4 result = new Double4();
        for (int i = 0; i < this.numElements; ++i) {
            result = Double4.max(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(DoubleBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public DoubleBuffer asBuffer() {
        return DoubleBuffer.wrap(this.storage.toHeapArray());
    }

    public DoubleBuffer asBuffer(DoubleBuffer buffer) {
        return this.asBuffer().put(buffer);
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public DoubleArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

