/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.DoubleBuffer;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Double3;

public final class VectorDouble3
implements TornadoCollectionInterface<DoubleBuffer> {
    public static final Class<VectorDouble3> TYPE = VectorDouble3.class;
    private static final int ELEMENT_SIZE = 3;
    private final DoubleArray storage;
    private final int numElements;

    VectorDouble3(int numElements, DoubleArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorDouble3(DoubleArray array) {
        this(array.getSize() / 3, array);
    }

    public VectorDouble3(int numElements) {
        this(numElements, new DoubleArray(numElements * 3));
    }

    public int vectorWidth() {
        return 3;
    }

    private int toIndex(int index) {
        return index * 3;
    }

    public Double3 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Double3 loadFromArray(DoubleArray array, int index) {
        Double3 result = new Double3();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        return result;
    }

    public void set(int index, Double3 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Double3 value, DoubleArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
    }

    public void set(VectorDouble3 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(DoubleArray values) {
        VectorDouble3 vector = new VectorDouble3(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(double value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorDouble3 duplicate() {
        VectorDouble3 vector = new VectorDouble3(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 3) {
            return String.format("VectorDouble3 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Double3 sum() {
        Double3 result = new Double3();
        for (int i = 0; i < this.numElements; ++i) {
            result = Double3.add(result, this.get(i));
        }
        return result;
    }

    public Double3 min() {
        Double3 result = new Double3();
        for (int i = 0; i < this.numElements; ++i) {
            result = Double3.min(result, this.get(i));
        }
        return result;
    }

    public Double3 max() {
        Double3 result = new Double3();
        for (int i = 0; i < this.numElements; ++i) {
            result = Double3.max(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(DoubleBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public DoubleBuffer asBuffer() {
        return DoubleBuffer.wrap(this.storage.toHeapArray());
    }

    public DoubleBuffer asBuffer(DoubleBuffer buffer) {
        return this.asBuffer().put(buffer);
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public DoubleArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

