/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.runtime;

import uk.ac.manchester.tornado.api.TornadoRuntime;
import uk.ac.manchester.tornado.api.TornadoSetting;
import uk.ac.manchester.tornado.api.runtime.TornadoAPIProvider;

public class TornadoRuntimeProvider {
    private static TornadoRuntime runtimeImpl;
    private static TornadoSetting tornadoImpl;

    private static void init() {
        if (runtimeImpl == null) {
            runtimeImpl = TornadoAPIProvider.loadTornadoRuntimeImpl();
        }
        if (tornadoImpl == null) {
            tornadoImpl = TornadoAPIProvider.loadTornadoImpl();
        }
    }

    public static TornadoRuntime getTornadoRuntime() {
        return runtimeImpl;
    }

    public static boolean isProfilerEnabled() {
        return runtimeImpl.isProfilerEnabled();
    }

    public static boolean isPowerMonitoringEnabled() {
        return runtimeImpl.isPowerMonitoringEnabled();
    }

    public static void setProperty(String key, String value) {
        tornadoImpl.setTornadoProperty(key, value);
    }

    public static String getProperty(String key, String value) {
        return tornadoImpl.getTornadoProperty(key, value);
    }

    public static String getProperty(String key) {
        return tornadoImpl.getTornadoProperty(key);
    }

    public static void loadSettings(String property) {
        tornadoImpl.loadTornadoProperty(property);
    }

    static {
        TornadoRuntimeProvider.init();
    }
}

