/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import uk.ac.manchester.tornado.api.WorkerGrid;

public class GridScheduler {
    private final ConcurrentHashMap<String, WorkerGrid> gridTaskMap = new ConcurrentHashMap();

    public GridScheduler() {
    }

    public GridScheduler(String taskName, WorkerGrid workerGrid) {
        this.gridTaskMap.put(taskName, workerGrid);
    }

    public void addWorkerGrid(String taskName, WorkerGrid workerGrid) {
        this.gridTaskMap.put(taskName, workerGrid);
    }

    public WorkerGrid get(String taskName) {
        return this.gridTaskMap.get(taskName);
    }

    public boolean contains(String taskScheduleName, String taskName) {
        return this.gridTaskMap.containsKey(taskScheduleName + "." + taskName);
    }

    public Set<String> keySet() {
        return this.gridTaskMap.keySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String taskName : this.gridTaskMap.keySet()) {
            sb.append(taskName).append("::GlobalWorkGroup=").append(Arrays.toString(this.gridTaskMap.get(taskName).getGlobalWork())).append("::LocalWorkGroup=").append(Arrays.toString(this.gridTaskMap.get(taskName).getLocalWork()));
        }
        return sb.toString();
    }
}

