/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api;

import uk.ac.manchester.tornado.api.WorkerGrid;

public abstract class AbstractWorkerGrid
implements WorkerGrid {
    protected long[] globalWork;
    protected long[] localWork;
    protected long[] numOfWorkgroups;
    protected long[] globalOffset;

    protected AbstractWorkerGrid(long x, long y, long z) {
        this.globalWork = new long[]{x, y, z};
        this.globalOffset = new long[]{0L, 0L, 0L};
    }

    @Override
    public long[] getGlobalWork() {
        return this.globalWork;
    }

    @Override
    public long[] getLocalWork() {
        return this.localWork;
    }

    @Override
    public long[] getNumberOfWorkgroups() {
        return this.numOfWorkgroups;
    }

    @Override
    public long[] getGlobalOffset() {
        return this.globalOffset;
    }

    @Override
    public void setGlobalWork(long x, long y, long z) {
        this.globalWork = new long[]{x, y, z};
    }

    @Override
    public void setLocalWork(long x, long y, long z) {
        this.localWork = new long[]{x, y, z};
        this.calculateNumberOfWorkgroups();
    }

    @Override
    public void setGlobalOffset(long x, long y, long z) {
        this.globalOffset = new long[]{x, y, z};
    }

    private void calculateNumberOfWorkgroups() {
        this.numOfWorkgroups = new long[this.globalWork.length];
        for (int i = 0; i < this.globalWork.length; ++i) {
            this.numOfWorkgroups[i] = this.globalWork[i] / this.localWork[i];
        }
    }

    @Override
    public void setLocalWorkToNull() {
        this.localWork = null;
    }

    @Override
    public void setNumberOfWorkgroupsToNull() {
        this.numOfWorkgroups = null;
    }
}

